#version 330
#extension GL_EXT_gpu_shader4 : enable
//Velvet TunnelMod01.fsh  by   AieKick
//https://www.shadertoy.com/view/MlGGW3
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by Stephane Cuillerdier - @Aiekick/2016
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

mat3 getRotXMat(float a){return mat3(1.,0.,0.,0.,cos(a),-sin(a),0.,sin(a),cos(a));}
mat3 getRotYMat(float a){return mat3(cos(a),0.,sin(a),0.,1.,0.,-sin(a),0.,cos(a));}
mat3 getRotZMat(float a){return mat3(cos(a),-sin(a),0.,sin(a),cos(a),0.,0.,0.,1.);}

mat3 mat;

vec2 path(float t)
{
	return vec2(cos(t*0.08), sin(t*0.08)) * 4.;
}

float pattern(vec3 p)
{
	p = abs(fract(p*.3) - 0.5);
	return length(p);
}

vec4 map(vec3 p)
{
	p.xy -= path(p.z);
    float d = min(pattern(p*mat), pattern(p*mat*mat)) / .9;
    vec3 col = vec3(1)-clamp(d,0.,1.);
   	float dist = dot(col,vec3(1));
	return vec4(5. - length(p.xy) - dist*.5, vec3(0));
}

vec3 nor( vec3 pos, float k )
{
	vec3 eps = vec3( k, 0., 0. );
	vec3 nor = vec3(
	    map(pos+eps.xyy).x - map(pos-eps.xyy).x,
	    map(pos+eps.yxy).x - map(pos-eps.yxy).x,
	    map(pos+eps.yyx).x - map(pos-eps.yyx).x );
	return normalize(nor);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec4 f = vec4(0);
    
    vec2 g = gl_FragCoord.xy;
    vec2 si = iResolution.xy;
    
    mat3 mx = getRotXMat(-7.);
	mat3 my = getRotYMat(-5.);
	mat3 mz = getRotZMat(-3.);
    mat = mx * my * mz;
    
    float time = iTime * 8.;
    
    vec3 camUp=vec3(0,1,0);//Change camere up vector here
  	vec3 camView=vec3(0,0,time + .1); //Change camere view here
	camView.xy += path(camView.z);
    
  	vec2 uv = (g+g-si)/si.y;
    
    vec3 ro = vec3(0,0,time);
	ro.xy += path(ro.z);
    
    vec3 ld = normalize(vec3(path(ro.z + 1.),ro.z + 0.) - ro);
    
  	vec3 rov = normalize(camView-ro);
    vec3 u = normalize(cross(camUp,rov));
  	vec3 v = cross(rov,u);
  	vec3 rd = normalize(rov + uv.x*u + uv.y*v);
    
    float s = 1.;
    float d = 0.;
    for(int i=0;i<60;i++)
    {      
        if (log(d*d/s/1e5)>0.) break;
        d += s = map(ro+rd*d).x * 0.5;
    }
	
    vec3 p = ro+rd*d;
    vec3 n = nor(p, 0.1);
        
    float amb = clamp( 0.5+0.5*n.y, 0.0, 1.0 );
    float dif = clamp( dot( n, ld ), 0.0, 1.0 );
    float spe = pow(clamp( dot( n, ld ), 0.0, 1.0 ),16.0);
    float spe2 = pow(clamp( dot( n, -ld ), 0.0, 1.0 ),16.0);
        
	f = vec4(0.8,0.5,0.2,1)*(amb + spe + spe2) + dif * map(p-n*3.);

    f = mix( f, vec4(0.8,0.9,1,1), 1.0-exp( -0.0005*d*d ) );
        
   	gl_FragColor = f;
}